import time
import LDAEth_module

TESTVERSION = "0.1 2020-10-19"

LDA_IPADDRESS="192.168.100.10"

STATUS_OK = 0
STATUS_ERROR = 1
SET_API_ENABLED = 0 # Set to 1 if SET API to be tested

LDAEth_module.fnLDA_Init()
print("LDA test/demonstration program version",TESTVERSION,
      "and wrapper version",LDAEth_module.WrapperVersion())
      
LDAEth_module.fnLDA_InitDevice(LDA_IPADDRESS)

if 0 == LDAEth_module.fnLDA_CheckDeviceReady(LDA_IPADDRESS):
    print("Device Ready..-)")
    modelname=LDAEth_module.fnLDA_GetModelName(LDA_IPADDRESS)    
    print("Model Name:",modelname)
    serialnumber=LDAEth_module.fnLDA_GetSerialNumber(LDA_IPADDRESS)    
    print("Serial Number:",serialnumber)
    swversion=LDAEth_module.fnLDA_GetSoftwareVersion(LDA_IPADDRESS)    
    print("SW Version:",swversion)
    ldafeature=LDAEth_module.fnLDA_GetFeatures(LDA_IPADDRESS)    
    print("LDA Features:",ldafeature)
    maxchannels=LDAEth_module.fnLDA_GetMaxChannels(LDA_IPADDRESS)    
    print("Max Channels:",maxchannels)
    ipmode=LDAEth_module.fnLDA_GetIPMode(LDA_IPADDRESS)    
    print("IP Mode:",ipmode)    
    ipaddress=LDAEth_module.fnLDA_GetIPAddress(LDA_IPADDRESS)    
    print("IP Address:",ipaddress)   
    netmask=LDAEth_module.fnLDA_GetNetmask(LDA_IPADDRESS)    
    print("Net Mask:",netmask)
    gateway=LDAEth_module.fnLDA_GetGateway(LDA_IPADDRESS)    
    print("Gateway:",gateway)
    minfrequency=LDAEth_module.fnLDA_GetMinWorkingFrequency(LDA_IPADDRESS)    
    print("Min Frequency:",minfrequency/10)
    maxfrequency=LDAEth_module.fnLDA_GetMaxWorkingFrequency(LDA_IPADDRESS)    
    print("Max Frequency:",maxfrequency)
    minattenuation=LDAEth_module.fnLDA_GetMinAttenuation(LDA_IPADDRESS)    
    print("Min Attenuation:",minattenuation/20.0)
    maxattenuation=LDAEth_module.fnLDA_GetMaxAttenuation(LDA_IPADDRESS)    
    print("Max Attenuation:",maxattenuation/20.0)
    rf_channel=LDAEth_module.fnLDA_GetChannel(LDA_IPADDRESS)    
    print("Channel:",rf_channel)
    rf_current_frequency=LDAEth_module.fnLDA_GetWorkingFrequency(LDA_IPADDRESS)    
    print("Frequency:",rf_current_frequency/10)
    rf_attenuation=LDAEth_module.fnLDA_GetAttenuation(LDA_IPADDRESS)    
    print("Attenuation:",rf_attenuation/20.0)
    rampstart_attenuation=LDAEth_module.fnLDA_GetRampStart(LDA_IPADDRESS)    
    print("Ramp Start:",rampstart_attenuation/20.0)
    rampstop_attenuation=LDAEth_module.fnLDA_GetRampEnd(LDA_IPADDRESS)    
    print("Ramp Stop:",rampstop_attenuation/20.0)
    ramp_dwelltime=LDAEth_module.fnLDA_GetDwellTime(LDA_IPADDRESS)    
    print("Dwell Time:",ramp_dwelltime)
    ramp_idletime=LDAEth_module.fnLDA_GetIdleTime(LDA_IPADDRESS)    
    print("Idle Time:",ramp_idletime)
    attenuationstep=LDAEth_module.fnLDA_GetAttenuationStep(LDA_IPADDRESS)    
    print("Attenuation Step Size:",attenuationstep)
    ramp_bidirectional_dwelltime=LDAEth_module.fnLDA_GetDwellTimeTwo(LDA_IPADDRESS)  
    print("Bi-directional Dwell Time:",ramp_bidirectional_dwelltime)
    ramp_bidirectional_holdtime=LDAEth_module.fnLDA_GetHoldTime(LDA_IPADDRESS)    
    print("Bi-directional Hold Time:",ramp_bidirectional_holdtime)
    attenuationsteptwo=LDAEth_module.fnLDA_GetAttenuationStepTwo(LDA_IPADDRESS)    
    print("Bi-direction Attenuation Step size:",attenuationsteptwo)
    profile_count=LDAEth_module.fnLDA_GetProfileCount(LDA_IPADDRESS)    
    print("Profile Count:",profile_count)
    profile_maxlength=LDAEth_module.fnLDA_GetProfileMaxLength(LDA_IPADDRESS)    
    print("Profile Maxlength:",profile_maxlength)
    profile_dwelltime=LDAEth_module.fnLDA_GetProfileDwellTime(LDA_IPADDRESS)    
    print("Profile Dwell Time:",profile_dwelltime)
    profile_idletime=LDAEth_module.fnLDA_GetProfileIdleTime(LDA_IPADDRESS)    
    print("Profile Idle Time:",profile_idletime)
    for index in range (0,profile_count):
        profile_data=LDAEth_module.fnLDA_GetProfileElement(LDA_IPADDRESS, index)    
        print("Get Profile Data status for element:",(index, profile_data))
        
    print("Data Read Done !")
    
    # Set API calls
    if (SET_API_ENABLED == 1):
        # Set channel
        if(LDAEth_module.fnLDA_SetChannel(LDA_IPADDRESS, 2)):
            print("Channel Set Error")
        
        # Set frequency-- // 200MHz = 200*10 in 100KHz Resolution
        if(LDAEth_module.fnLDA_SetWorkingFrequency(LDA_IPADDRESS, 2000)): 
            print("Set Frequency Error")
        
        # Set attenuation -- // Setting Attenuation to 35dB - 35*20 in 0.05dB Resolution
        if(LDAEth_module.fnLDA_SetWorkingFrequency(LDA_IPADDRESS, 35*20)):
            print("Set Attenuation Error")
    
else:
    print("Device not Ready !...")

LDAEth_module.print_hello_world()
